// parse a FritzBox Bpjm File

package main

import (
	"os"
	"fmt"
	"bytes"
	"io"
	"io/ioutil"
)

// error checking function that panics on error
func check(err error) {
	if err != nil {
		panic(err)
	}
}

// cut away null byte padding
func cutNullBytes (data []byte) (nd []byte) {
	nd = bytes.Trim(data, string(0x00))
	return nd
}

func main() {
	// get filename to parse
	filename := os.Args[1]
	// read in file
	dat, err := ioutil.ReadFile(filename)
    check(err)
	// make a bytes buffer of file content
	buf := bytes.NewBuffer(dat)
	// print legth of buffer
	fmt.Printf("Länge der eingelesenen Daten: %d bytes\n", buf.Len())
	// extract magick number
	magick := buf.Next(5)
	fmt.Printf("Magick: %x\n", magick)
	// extract embedded filename
	embed_filename := buf.Next(59)
	fmt.Printf("Filename: %s\n", string(cutNullBytes(embed_filename)))
	// parse the rest of the file (actual bpjm list data)
	n := 0
	for {
		entry := make([]byte, 33)
		_, err := buf.Read(entry)
		if err != nil {
			if err == io.EOF {
				break
			}
			panic(err)
		}
		//fmt.Printf("%x_%04d: %x %x %x\n", magick, n, entry[0:15], entry[16:31], entry[32])
		fmt.Printf("%s_%04d: %x %x %x\n", cutNullBytes(embed_filename), n, entry[0:15], entry[16:31], entry[32])
		n++
	}
}