// tool that uses my bpjm library to load and parse a BPJM File from a FritzBox
package main

import(
	"github.com/scusi/bpjm"
	"fmt"
	"os"
)

func main(){
	filename := os.Args[1]
	data := Bpjm.LoadFritzBoxFile(filename)
	obj := Bpjm.ParseFritzBoxFile(data)
	fmt.Printf("File Magick:  %x\n", obj.Magick)
	fmt.Printf("Filen Name:   %s\n", obj.EmbedFileName)
	fmt.Printf("File Size:    %d bytes\n", obj.Size)
	fmt.Printf("File Records: %d\n", obj.Records)
	n := 0
	for i, _ := range obj.Entries {
		fmt.Printf("%x ", obj.Entries[i].DomainMd5)
		fmt.Printf("%x ", obj.Entries[i].PathMd5)
		fmt.Printf("%x\n", obj.Entries[i].Depth)
		n++
	}
}

// TODO: integrate json marshaller