##
## IMAP CREDENTIALS
##
set smtp_url = "smtp://some_user@smtp.gmail.com:587/"
#set smtp_pass = "password"
set from = "someuser@example.com"
set realname = "Some User"

##
## IMAP SETTINGS
##
# activate TLS if available on the server
set ssl_starttls=yes
# always use SSL when connecting to a server
set ssl_force_tls=yes
# Don't wait to enter mailbox manually 
unset imap_passive        
# Automatically poll subscribed mailboxes for new mail (new in 1.5.11)
set imap_check_subscribed


##
## GMAIL SPECIFIC
##
set folder = "imaps://imap.gmail.com:993"
set spoolfile = "+INBOX"
set postponed="+[Gmail]/Drafts"
#set record="+[Gmail]/Sent Mail" # Causes duplicates in Gmail
#set trash="+[Gmail]/Bin" # If disabled, mail will be archived (in Gmail)

##
## GENERIC
##
set header_cache=~/.mutt/cache/headers
set message_cachedir=~/.mutt/cache/bodies
set certificate_file=~/.mutt/certificates
# Move read messages from your spool mailbox to your $mbox mailbox
set move = no
# Reduce polling frequency to a sane level
set mail_check=60
# And poll the current mailbox more often (not needed with IDLE in post 1.5.11)
set timeout=10
# keep a cache of headers for faster loading (1.5.9+?)
set header_cache=~/.hcache
# Display download progress every 5K
set net_inc=5
# Don't switch to next mail when paging down in a mail and hitting bottom
set pager_stop=yes
# Confirm quit
set quit=ask-yes
# Date format in index view. Standard strftime syntax.
set date_format="!%a, %b %d, %Y at %I:%M:%S%p %Z"
# Default index format
#set index_format="%4C %Z %{%b %d} %-15.15L (%?l?%4l&%4c?) %s"
set index_format="%4C %Z %{%b %d %H:%M}  %-15.15L (%?l?%4l&%4c?) %s"

